/*******************************************************
Filename		:  	DW_process_data_request.sql
Release 		:  	STORET c2.0.5
SIR			:  	1633
Description		:  	Processes the batch data request by reading recorded information from dw_data_requests table for a given request_id.
Author		:	Ganesh Thadkamalla
Date			: 	August 11, 2005
       09/14/2005 - Added query_text2. -GT
	12/13/2006 - modified for metadata CR. - Suganthi.
	12/23/2006 - modified for metadat - Suganthi
01/01/2007 - edited for ALLRESULTS. - Ganesh
03/29/2007 - v2062 . edited for filenames -Ganesh
Comments		:  	
**********************************************************/
CREATE OR REPLACE procedure dw_process_data_request(p_req_id in number)
as

  lr_data_req dw_data_requests%rowtype;
  TYPE sds_cur IS REF CURSOR;
  sdsdata sds_cur;

  my_out_file		UTL_FILE.FILE_TYPE;
  out_file_name		VARCHAR2(30);
  iodir         		VARCHAR2(100);
  download_path 		VARCHAR2(100);
  sdrec varchar2(32000);
  lv_isn  number;
  v_zip_rc                number := 0;
  v_file_name             varchar2(200);
  v_exists 		      boolean;
  v_file_length 		number;
  v_blocksize 		number;
  v_time_start		number;
  v_time_current		number;
  lv_filesize_kb  number;
  lv_email_body varchar2(4000);
  lv_request_type varchar2(30);

--[META DATA]
  lv_sqlstmt       VARCHAR2(8000);
  v_mdata_filename    VARCHAR2(50);
  v_sqlstmt       VARCHAR2(2000);
  v_Stmt  VARCHAR2(8000);
  v_CursorID              INTEGER;
  v_ReturnRow             VARCHAR2(32000);
  v_Dummy                 INTEGER;
  i                       INTEGER;
  v_orgidlist             owa_util.ident_arr;
  lv_file_name varchar2(100);
  lv_filetype varchar2(3);
  lv_timestamp varchar2(20);
  v_tarfile varchar2(100);
  v_filename_ts           VARCHAR2(30);
--  lv_command varchar2(4000);
  lv_command varchar2(32000);
  lv_zipfile varchar2(200);
  lv_basefile varchar2(200);
--  lv_project_blobs varchar2(4000);
  lv_project_blobs varchar2(30000);

  lv_reg_file varchar2(200);
  lv_bio_file varchar2(200);
  lv_hab_file varchar2(200);
  lv_stn_file varchar2(200);
  --********************************
  lv_reg_data varchar2(10);
  lv_bio_data varchar2(10);
  lv_hab_data varchar2(10);

begin
select * into lr_data_req from dw_data_requests
where request_id = p_req_id;
  iodir := DW_GLOB_VAR.LV_IODIR;

  --ALLRESULTS
  lv_reg_data:='NO';
  lv_bio_data:='NO';
  lv_hab_data :='NO';
  
  lv_basefile:=substr(lr_data_req.filename,1,instr(lr_data_req.filename,'.txt')-1);
--v2062
    --lv_reg_file:=lv_basefile||'_1REG.txt';
	--lv_bio_file:=lv_basefile||'_1BIO.txt';
	--lv_hab_file:=lv_basefile||'_1HAB.txt';
	lv_reg_file:='Data_'||replace(lr_data_req.filename,'.txt','_RegResults.txt');
	lv_bio_file:='Data_'||replace(lr_data_req.filename,'.txt','_BioResults.txt');
	lv_hab_file:='Data_'||replace(lr_data_req.filename,'.txt','_HabResults.txt');
        lv_stn_file:='Data_'||replace(lr_data_req.filename,'.txt','_Stations.txt');
--*************
--[METADATA]
 IF lr_data_req.request_type='SDA' THEN
  --PRECCESSING REGULAR RESULT
  lv_sqlstmt:=lr_data_req.RQUERY_TEXT||lr_data_req.Rquery_text2;
  v_Stmt:= substr(lv_sqlstmt,instr(upper(lv_sqlstmt),' FROM '));
  v_sqlstmt:='SELECT distinct FA.organization_id'||' '||v_Stmt;

  v_CursorID := DBMS_SQL.OPEN_CURSOR;
  DBMS_SQL.PARSE(v_CursorID, v_sqlstmt, DBMS_SQL.NATIVE);
  DBMS_SQL.DEFINE_COLUMN(v_CursorID, 1, v_ReturnRow, 32000);
  v_Dummy := DBMS_SQL.EXECUTE(v_CursorID);

          i := 1;
		  --i:=v_orgidlist.last+1;
          LOOP
              IF DBMS_SQL.FETCH_ROWS(v_CursorID) = 0 THEN
	        	EXIT;
              END IF;
          DBMS_SQL.COLUMN_VALUE(v_CursorID, 1, v_ReturnRow);
          v_orgidlist(i) := v_ReturnRow;
		  lv_reg_data:='YES';
          i :=	i+1;
          END LOOP;
          DBMS_SQL.CLOSE_CURSOR(v_CursorID);

 --PRECCESSING biological RESULT
  lv_sqlstmt:=lr_data_req.bQUERY_TEXT||lr_data_req.bquery_text2;
  v_Stmt:= substr(lv_sqlstmt,instr(upper(lv_sqlstmt),' FROM '));
  v_sqlstmt:='SELECT distinct FA.organization_id'||' '||v_Stmt;

  v_CursorID := DBMS_SQL.OPEN_CURSOR;
  DBMS_SQL.PARSE(v_CursorID, v_sqlstmt, DBMS_SQL.NATIVE);
  DBMS_SQL.DEFINE_COLUMN(v_CursorID, 1, v_ReturnRow, 32000);
  v_Dummy := DBMS_SQL.EXECUTE(v_CursorID);

          --i := 1;
		  i:=v_orgidlist.last+1;
          LOOP
              IF DBMS_SQL.FETCH_ROWS(v_CursorID) = 0 THEN
	        	EXIT;
              END IF;
          DBMS_SQL.COLUMN_VALUE(v_CursorID, 1, v_ReturnRow);
          v_orgidlist(i) := v_ReturnRow;
		  lv_bio_data:='YES';
          i :=	i+1;
          END LOOP;
          DBMS_SQL.CLOSE_CURSOR(v_CursorID);

	 --PRECCESSING biological RESULT
  lv_sqlstmt:=lr_data_req.hQUERY_TEXT||lr_data_req.hquery_text2;
  v_Stmt:= substr(lv_sqlstmt,instr(upper(lv_sqlstmt),' FROM '));
  v_sqlstmt:='SELECT distinct FA.organization_id'||' '||v_Stmt;

  v_CursorID := DBMS_SQL.OPEN_CURSOR;
  DBMS_SQL.PARSE(v_CursorID, v_sqlstmt, DBMS_SQL.NATIVE);
  DBMS_SQL.DEFINE_COLUMN(v_CursorID, 1, v_ReturnRow, 32000);
  v_Dummy := DBMS_SQL.EXECUTE(v_CursorID);

          --i := 1;
		  i:=v_orgidlist.last+1;
          LOOP
              IF DBMS_SQL.FETCH_ROWS(v_CursorID) = 0 THEN
	        	EXIT;
              END IF;
          DBMS_SQL.COLUMN_VALUE(v_CursorID, 1, v_ReturnRow);
          v_orgidlist(i) := v_ReturnRow;
		  lv_hab_data:='YES';
          i :=	i+1;
          END LOOP;
          DBMS_SQL.CLOSE_CURSOR(v_CursorID);

 ELSE
  if lr_data_req.query_text2 is null then
  lv_sqlstmt:=lr_data_req.QUERY_TEXT;
  else
  lv_sqlstmt:=lr_data_req.QUERY_TEXT||lr_data_req.query_text2;
  end if;

     v_Stmt:= substr(lv_sqlstmt,instr(upper(lv_sqlstmt),' FROM '));

  v_sqlstmt:='SELECT distinct FA.organization_id'||' '||v_Stmt;

  v_CursorID := DBMS_SQL.OPEN_CURSOR;
  DBMS_SQL.PARSE(v_CursorID, v_sqlstmt, DBMS_SQL.NATIVE);
  DBMS_SQL.DEFINE_COLUMN(v_CursorID, 1, v_ReturnRow, 32000);
  v_Dummy := DBMS_SQL.EXECUTE(v_CursorID);

          i := 1;
          LOOP
              IF DBMS_SQL.FETCH_ROWS(v_CursorID) = 0 THEN
		EXIT;
              END IF;
          DBMS_SQL.COLUMN_VALUE(v_CursorID, 1, v_ReturnRow);
          v_orgidlist(i) := v_ReturnRow;
          i :=	i+1;
          END LOOP;
          DBMS_SQL.CLOSE_CURSOR(v_CursorID);
 END IF;

  
IF lr_data_req.request_type= 'SDA' THEN
-- Process regular results
IF LV_REG_DATA='YES' THEN
OPEN sdsdata FOR lr_data_req.RQUERY_TEXT||lr_data_req.rquery_text2;
  --my_out_file := UTL_FILE.FOPEN(iodir,replace(lr_data_req.filename,'SDA2','SDR2'),'W',30000);
  --v2062
  my_out_file := UTL_FILE.FOPEN(iodir,lv_reg_file,'W',30000);
  
  --
  UTL_FILE.PUT_LINE(my_out_file,lr_data_req.r_record_title);
  LOOP
    FETCH sdsdata INTO sdrec;
    EXIT WHEN sdsdata%NOTFOUND;
    UTL_FILE.PUT_LINE(my_out_file,sdrec);
  END LOOP;

  CLOSE sdsdata;
  UTL_FILE.FCLOSE(my_out_file);
END IF;
-- process the biological results
IF LV_BIO_DATA='YES' THEN
OPEN sdsdata FOR lr_data_req.bQUERY_TEXT||lr_data_req.bquery_text2;
  --my_out_file := UTL_FILE.FOPEN(iodir,replace(lr_data_req.filename,'SDA2','SDB2'),'W',30000);
  my_out_file := UTL_FILE.FOPEN(iodir,lv_bio_file,'W',30000);
  ----
  UTL_FILE.PUT_LINE(my_out_file,lr_data_req.b_record_title);
  LOOP
    FETCH sdsdata INTO sdrec;
    EXIT WHEN sdsdata%NOTFOUND;
    UTL_FILE.PUT_LINE(my_out_file,sdrec);
  END LOOP;

  CLOSE sdsdata;
  UTL_FILE.FCLOSE(my_out_file);
END IF;
-- process the habitat results
IF LV_HAB_DATA='YES' THEN
OPEN sdsdata FOR lr_data_req.hQUERY_TEXT||lr_data_req.hquery_text2;
  --my_out_file := UTL_FILE.FOPEN(iodir,replace(lr_data_req.filename,'SDA2','SDH2'),'W',30000);
  --
  my_out_file := UTL_FILE.FOPEN(iodir,lv_hab_file,'W',30000);
  --
  UTL_FILE.PUT_LINE(my_out_file,lr_data_req.h_record_title);
  LOOP
    FETCH sdsdata INTO sdrec;
    EXIT WHEN sdsdata%NOTFOUND;
    UTL_FILE.PUT_LINE(my_out_file,sdrec);
  END LOOP;

  CLOSE sdsdata;
  UTL_FILE.FCLOSE(my_out_file);
 END IF;
ELSE
-- Process the request.
OPEN sdsdata FOR lr_data_req.QUERY_TEXT||lr_data_req.query_text2;

  iodir := DW_GLOB_VAR.LV_IODIR;
  
  --my_out_file := UTL_FILE.FOPEN(iodir,lr_data_req.filename,'W',30000);
  --
  --UTL_FILE.PUT_LINE(my_out_file,lr_data_req.record_title);

IF lr_data_req.request_type = 'SDS' THEN
  my_out_file := UTL_FILE.FOPEN(iodir,lv_stn_file,'W',30000);
  UTL_FILE.PUT_LINE(my_out_file,lr_data_req.record_title);
ELSIF lr_data_req.request_type = 'SDR' THEN
  my_out_file := UTL_FILE.FOPEN(iodir,lv_REG_file,'W',30000);
  UTL_FILE.PUT_LINE(my_out_file,lr_data_req.record_title);
ELSIF lr_data_req.request_type = 'SDB' THEN
  my_out_file := UTL_FILE.FOPEN(iodir,lv_BIO_file,'W',30000);
  UTL_FILE.PUT_LINE(my_out_file,lr_data_req.record_title);
ELSIF lr_data_req.request_type = 'SDH' THEN
  my_out_file := UTL_FILE.FOPEN(iodir,lv_HAB_file,'W',30000);
  UTL_FILE.PUT_LINE(my_out_file,lr_data_req.record_title);
END IF;


IF lr_data_req.request_type = 'SDS' THEN
  LOOP
    FETCH sdsdata INTO lv_isn,sdrec;
    EXIT WHEN sdsdata%NOTFOUND;
    UTL_FILE.PUT_LINE(my_out_file,sdrec);
  END LOOP;
ELSIF lr_data_req.request_type IN ('SDR','SDB','SDH') THEN
  LOOP
    FETCH sdsdata INTO sdrec;
    EXIT WHEN sdsdata%NOTFOUND;
    UTL_FILE.PUT_LINE(my_out_file,sdrec);
  END LOOP;
END IF;

  CLOSE sdsdata;
  UTL_FILE.FCLOSE(my_out_file);

END IF;  --sda

--***************************************************************************
  --[META DATA]


            --v_mdata_filename := replace(lr_data_req.filename,'.txt','_MD.txt');
        v_mdata_filename := 'Data_'||replace(lr_data_req.filename,'.txt','_Metadata.txt');

            v_tarfile:= replace(lr_data_req.filename,'.txt','.tar');
--dbms_output.put_line('starting MD procedure');
	if lr_data_req.request_type in ('SDR','SDB','SDH','SDA') THEN
         DW_RESULT_METADATA(v_orgidlist,v_mdata_filename,lv_project_blobs);
		 dbms_output.put_line('processed MD procedure');
         lv_basefile:=substr(lr_data_req.filename,1,instr(lr_data_req.filename,'.txt')-1);
         --lv_command :='/bin/tar -cf '||DW_glob_var.lv_iodir||'/'||v_tarfile||' '|| DW_glob_var.lv_iodir||'/'||lr_data_req.filename||' '||DW_glob_var.lv_iodir||'/'||v_mdata_filename;
         --lv_command :='/bin/tar -cf '||DW_glob_var.lv_iodir||'/'||v_tarfile||' '|| DW_glob_var.lv_iodir||'/'||lr_data_req.filename||'*';
         --lv_command :='/bin/tar -cf '||DW_glob_var.lv_iodir||'/'||v_tarfile||'  -C '||DW_glob_var.lv_iodir||'  '||lv_basefile||'.txt '||lv_basefile||'_MD.txt';
         --lv_command :='/bin/tar -cf '||DW_glob_var.lv_iodir||v_tarfile||'   '||'`/bin/ls '||DW_glob_var.lv_iodir||lv_basefile||'*`';
        IF lr_data_req.request_type = 'SDA' THEN
--		 lv_reg_file:=replace(lv_basefile,'SDA2','SDR2')||'.txt';
--		 lv_bio_file:=replace(lv_basefile,'SDA2','SDB2')||'.txt';
--		 lv_hab_file:=replace(lv_basefile,'SDA2','SDH2')||'.txt';

    	 --lv_reg_file:=lv_basefile||'_1REG.txt';
		 --lv_bio_file:=lv_basefile||'_1BIO.txt';
		 --lv_hab_file:=lv_basefile||'_1HAB.txt';

--		 lv_command :='/bin/tar -cf '||DW_glob_var.lv_iodir||'/'||v_tarfile||'  -C '||DW_glob_var.lv_iodir||'  '||lv_reg_file||' '||lv_bio_file||' '||lv_hab_file||' '||lv_basefile||'_MD.txt '||lv_project_blobs;


		 lv_command :='/bin/tar -cf '||DW_glob_var.lv_iodir||'/'||v_tarfile||'  -C '||DW_glob_var.lv_iodir||'  '||lv_reg_file||' '||lv_bio_file||' '||lv_hab_file||' '||v_mdata_filename||' '||lv_project_blobs;


        ELSIF lr_data_req.request_type = 'SDR' THEN

lv_command :='/bin/tar -cf '||DW_glob_var.lv_iodir||'/'||v_tarfile||'  -C '||DW_glob_var.lv_iodir||'  '||lv_REG_FILE||' '||v_mdata_filename||' '||lv_project_blobs;

        ELSIF lr_data_req.request_type = 'SDB' THEN

lv_command :='/bin/tar -cf '||DW_glob_var.lv_iodir||'/'||v_tarfile||'  -C '||DW_glob_var.lv_iodir||'  '||lv_BIO_FILE||' '||v_mdata_filename||' '||lv_project_blobs;

        ELSIF lr_data_req.request_type = 'SDH' THEN

lv_command :='/bin/tar -cf '||DW_glob_var.lv_iodir||'/'||v_tarfile||'  -C '||DW_glob_var.lv_iodir||'  '||lv_HAB_FILE||' '||v_mdata_filename||' '||lv_project_blobs;

        ELSIF lr_data_req.request_type = 'SDS' THEN
NULL;
	END IF;
/*
		ELSE
         lv_command :='/bin/tar -cf '||DW_glob_var.lv_iodir||'/'||v_tarfile||'  -C '||DW_glob_var.lv_iodir||'  '||lv_basefile||'.txt '||lv_basefile||'_MD.txt '||lv_project_blobs;
        END IF;
*/
		 dbms_output.put_line(lv_basefile);
		  --dbms_output.put_line(lv_command);
		  dw_result_download_zip(lv_command,v_tarfile);

		  dbms_lock.sleep(5);

	lv_command:='/bin/gzip '||DW_glob_var.lv_iodir||'/'||v_tarfile;
dbms_output.put_line(lv_command);
dbms_output.put_line('starting compression');
         dw_result_download_zip(lv_command,v_tarfile||'.gz');
         lv_zipfile:=v_tarfile||'.gz';
		 dbms_output.put_line('end of compression');

        ELSIF lr_data_req.request_type in ('SDS') THEN
	  dbms_lock.sleep(5);
--     	  lv_command:='/bin/gzip '||DW_glob_var.lv_iodir||'/'||lr_data_req.filename;
          --v2062
--     	  lv_command:='/bin/gzip -C '||DW_glob_var.lv_iodir||'/'||lv_stn_file||' > '||DW_glob_var.lv_iodir||'/'||lr_data_req.filename||'.gz' ;
   	  lv_command:='/bin/gzip '||DW_glob_var.lv_iodir||'/'||lv_stn_file;
           dw_result_download_zip(lv_command,lv_stn_file||'.gz');
--           dw_result_download_zip(lv_command,lr_data_req.filename||'.gz');
--           lv_zipfile:=lr_data_req.filename||'.gz';
           lv_zipfile:=lv_stn_file||'.gz';
	END IF;
   dbms_lock.sleep(5);

  --*****
 --[META DATA]
 /*

  v_zip_rc := execmd('/bin/gzip -f '||DW_glob_var.lv_iodir||'/'||lr_data_req.filename);

  v_time_start := to_number(TO_CHAR(SYSDATE,'HH24')+TO_CHAR(SYSDATE,'MI')/60+ TO_CHAR(SYSDATE,'SS')/3600);
  LOOP
     utl_file.fgetattr(DW_GLOB_VAR.lv_iodir,lr_data_req.filename||'.gz',v_exists,v_file_length,v_blocksize);
     v_time_current := to_number(TO_CHAR(SYSDATE,'HH24')+TO_CHAR(SYSDATE,'MI')/60+ TO_CHAR(SYSDATE,'SS')/3600);
    EXIT WHEN v_file_length > 0 OR ABS(v_time_start-v_time_current)> 0.01667;
  END LOOP;

  v_time_start := to_number(TO_CHAR(SYSDATE,'HH24')+TO_CHAR(SYSDATE,'MI')/60+TO_CHAR(SYSDATE,'SS')/3600);
  LOOP
    v_time_current := to_number(TO_CHAR(SYSDATE,'HH24')+TO_CHAR(SYSDATE,'MI')/60+ TO_CHAR(SYSDATE,'SS')/3600);
    EXIT WHEN ABS(v_time_start-v_time_current)> 0.004;
  END LOOP;
*/

-- check the file size
--sug commented as part of the metadatareport
 -- utl_file.fgetattr(DW_GLOB_VAR.lv_iodir,lr_data_req.filename||'.gz',v_exists,v_file_length,v_blocksize);
   utl_file.fgetattr(DW_GLOB_VAR.lv_iodir,lv_zipfile,v_exists,v_file_length,v_blocksize);

    IF v_exists THEN
      lv_filesize_kb:=ROUND(v_file_length/1024,1);
      dbms_output.put_line(lr_data_req.email_address);

    update dw_data_requests
    set request_status='Completed',
        filesize_kb = lv_filesize_kb,
        processed_date =sysdate
    where request_id = p_req_id;
    commit;
select decode(lr_data_req.request_type,'SDS','Station Description','SDR','Regular Result','SDB','Biological Result','SDH','Habitat Result',lr_data_req.request_type) into lv_request_type from dual;

-- Email body
lv_email_body:= 'Your request for STORET '||lv_request_type||' download is completed via '||lr_data_req.request_mode||' batch processing.  The Request_ID is '||p_req_id||'.  You can download your file (size : '||lv_filesize_kb||' KB) using the hyperlink '||dw_glob_var.lv_download_path||lv_zipfile;

-- send an email.
    dw_mail_pkg.send
    ( p_sender_email => dw_glob_var.gv_storet_email,
       p_from => 'STORET Web Site <'||dw_glob_var.gv_storet_email||'>',
       p_to => dw_mail_pkg.array( lr_data_req.email_address),
       p_subject => 'STORET data request status (COMPLETED).  Request_ID: '||p_req_id,
       p_body => lv_email_body);

--update dw_data_requests table.
  update dw_data_requests
  set notified = 'Y',
      processed_date=sysdate
  where request_id = p_req_id;
  commit;

   END IF;
commit;

exception when others then
  update dw_data_requests
  set request_status = 'Failed',
      processed_date=sysdate
  where request_id = p_req_id;
  commit;

  dbms_output.put_line(sqlerrm);
end;
/



show errors

